## Send to Event Bus

This step sends a message to the Ambience Event Bus.
Messages consist of an event type (a string) and a document.

All modules on all hosts which share the same Ambience database will see items 
published to the event bus.

### Structure
1 => 1

### Input
A record with an optional elxEventType field.

### Parameters

* `Event Type` - the event type of the message being sent. Receivers will use this to decide how
  to response to the message. Event types are usually in the form "from/XXX/YYY", for example "kernel/ready" 
  is sent by each new machine which joins a cluster of servers. If this field is left blank, then it is expected
  that the incoming record will have a string field `elxEventType` and this will be used.
 
* `Document Field` - the document to send as the body of the message. If this is empty the entire 
   incoming record is passed as the message. 

### Output
Each incoming record will be passed through unchanged.

#### Notes

* A warning will be written to the job log if no Event Type is supplied or available (elxEventType) from the 
  incoming record. No message will be sent in this scenario.

* If the document field is not empty, but does not exist, or does not hold a document, an empty document is sent. 
  Use this in the case you want to send an empty document, as leaving the document field blank will send 
  the entire incoming record.
 
#### See Also

