## Set User Extra Fields

This step sets the extraFields an Ambience user.
This step will only work for administrators with mod-users privilege.

### Structure
1 => 1

### Input
A record containing the following fields (other fields are ignored):

* userId - a string holding the user id either as a BsonObjectId, or the string equivalent (hex value)
* extraFields - a nested object holding the new fields to set

### Parameters

None

### Output
Each incoming record will be annotated with the result of the operation. The extra fields added are:

`success` - whether the update was successful (boolean)

`error` - the error message, only when success = false

#### Notes

* To avoid overwriting extraFields entirely, it is good practice to read the current value, using List Users, make
  changes and then set them back. For example, if you want to set `landingPage`, don't just supply 
  ```
  { userId: "<some value>, extraFields: { landingPage: "<new value>" } }  
  ```
  because this will overwrite all other extra fields as well.

#### See Also

* List Users

