## Array Chain Each Item
This step allows a chain to be called for each element in an array. The result is stored inside the array.
The exact structure depends on the value of 1 => 1 used. 

If 1 => 1 is true, then only the first record output from the chain is taken and stored in the array.

If 1 => 1 is false, then an array is added inside the array element (making a nested array) holding all the chain 
results for that input item.

Unlike "Array Chain Each", this is a step that produces one record out for each record in - 
it is only the array that is altered.

### Structure
1 => 1

### Input
Records that have an array input field to be acted upon

### Parameters
* Input Field - the array field to read from

* Chain Name - the name of chain to apply to each element in the array

* 1 => 1 - whether to use 1 => 1 mode which discard more than the initial output record from the chain.

### Output
For each record in, there is one record out. The chain is executed multiple times, once per element of the array.
The results are used to build a new array to replace the original.

#### Notes
* If the input field is not an array field or doesn't exist, then the record is passed through unchanged.
 
* If the input array contains documents, then each document is passed as the parameters to the chain. 

* If the input array contains values, then a document is constructed: {"value": XX} and each constructed 
document is passed as the parameters to the chain.

* If the output record is a simple {"value": XX} structure, then XX is extracted - this is symmetrical with the input
processing.

* If a called chain produces no records, the behaviour differs between modes. In 1=>1 mode, the item is removed,
  otherwise, the item holds an empty array. (When 1=>1 mode is false, each item in the array is always replaced
  with a new array, so the result is always nested.)

### See Also

* Array Chain Each 
