## Array Concatenate

This step appends two existing field values to make an array field.
This step is different from Array Append, because if both values are arrays they will be joined in sequence, whereas
with append the value array will be inserted as a single item in the target (creating an array within an array).

This step combines two values, converting them both to arrays using this logic:

* If the value doesn't exist, it is equivalent to an empty array
* If the value is not an array, it is equivalent to an array with a single value
* If the value is an array, no change is needed

When both values (From #1 and From #2) are arrays, they are combined by appending the From #2 Value onto the end
of the From #1 and writing the resulting array (it is always an array) into the To Array field.

### Structure
1 => 1

### Input
No input requirements

### Parameters
* From #1 - the first value(s) to append to the array
 
* From #2 - the second value(s) to append to the array

* To Array - the array field to be created (any existing value will be overwritten)

### Output
The incoming record with the array added

#### Notes

* Based on the logic shown above, if neither From #1 or #2 exists, the To Array output is an empty array.

#### See Also

* Array Append

* Array Set

* Array Set (Field)
