## Array Lookup

This step looks up a value in an array of key/value pairs. 

Given this input:
```
[
  {"In": "EN", "Out": "Hello", "Comment": "Anything else"},
  {"In": "FR", "Out": "Bonjour", "Comment": "Other fields can be present"},
  ...
]
```
a Lookup with Key=In, Value=Out, KeyValue="FR" will locate "Bonjour. 

This step will scan the array, looking for the first value of Key which matches KeyValue and 
output the corresponding field called "Value" from the same array element.

In effect, this is using an array like a lookup map (of key/value pairs). 

### Structure
1 => 1

### Input
Records that have an array input field to be scanned

### Parameters
* Array - the name of array field to read

* Key - the name of the field within the array element to test

* Value - the name of the field within the array element to use

* Key Value - the (JSON) value of the Key to find. So for a String it should be "EN", not just EN.

* Output - the field into which the result (the Value of the found element) will be stored

### Output
The input record, with an additional Output field, if a matching key/value pair was found.

#### Notes
* If the input field is not an array field or doesn't exist, then the record is passed through unchanged.

#### See Also

* Array Lookup Field
