## Array Paginate

This step converts each record in holding an array into a series of records out, 
each holding a slice from the array, where the length of the slice is limited to a 
fixed page size. 

For example, given an input array of 70 items and a page size of 20, 
the output will be four records, the first three holding 20 items and the final one holding 10. 
(20,20,20,10) = 70.  

Only the array field is altered, other fields are passed through unchanged.

### Structure
1 => N

### Input
Records that have an array input field to be acted upon

### Parameters
* Array Field - the name of array field to read

* Page Size - the maximum size of each page slice

### Output
The input record repeated with each page-size slice of the array substituted into the same field name 

#### Notes
* If the input field is not an array field or doesn't exist, then the record is passed through unchanged.

* If the page size is 0, the record is passed through unchanged.

* Using a page size of 1 gives a similar result as Unwind, except in this step, the output field is still an array.

#### See Also

* Array Slice
 
* Array Slice (Field) 

* Array Unwind
