## Array Remove Items

This step removes any items from an array field which match a given test field value.

### Structure
1 => 1

### Input
Records that have an array input field to be acted upon and a test field to compare against.

There are two variants:
* Item field is empty: the `Equals Field` will be tested against each item in the array
 
* Item field is defined: the `Equals Field` will be tested against that field inside each item in the array 

### Parameters
* Array Field - the name of array field to modify
 
* Item Field - the name of field within the array item to test (may be empty, to test the whole item)
 
* Equals Field - the name of field to test against each item

### Output
The incoming document with the output array field modified to remove any items which meet the removal criteria

#### Notes
* If the array field does not hold an array or doesn't exist, then the record is passed through unchanged.

* If the equals field does not exist, then the record is passed through unchanged. 

* If the item field is defined, but does not exist in a particular array item, then the item will not be removed. 

#### See Also

