## Azure List

This step lists the contents of an Azure blob container

### Structure
1 => N

### Input

Each incoming record should contain a path to read.

### Parameters

* `Container` - the name of the blob container information to use from System Settings Azure Integration.

* `Path Field` - the incoming string field holding the path to be appended to the bucket path.

### Output

The incoming record is returned once for each child of the requested path, with additional fields:

* `name` - The name of the Azure content

* `length` - The size in bytes of the Azure content
 
* `lastModified` - The last modified timestamp of the Azure content (as a BsonDateTime)

If the request fails, then an `error` string is added instead

### Notes

* The container path and incoming path strings are directly concatenated. If you need a separator slash you should put it
  on the end of the container path or on the start of the incoming path string (but not both!).

* If the combined path is an empty folder then this step can return 0 records, which means 
  downstream steps will not run

### See Also

* Azure Delete

* Azure Get

* Azure Put
