## Bytes to String (Field)

This step converts binary data into a string according to a particular encoding.
There are many possible encodings and it is possible the requested encoding is not supported by your
JVM platform. Both the binary data and the encoding are supplied from the input

### Structure
1 ⇒ 1

### Input
* A record with a binary field and an encoding field

### Parameters
* `Bytes Field` - Field which holds the bytes to decode.
* `Encoding Field` - Field which holds the encoding to use, eg. utf-8 or iso-8859-1 etc. 
* `Result Field` - Field to store the output string.

### Output
THe input record with the additional result string, if the encoding is supported.

#### Notes
* Given the number of possible encodings and variation betweeen JVM version, host OS and even JVM vendor, 
use the debug option on this step to see any exceptions due to unsupported encodings.

#### See Also

* Bytes to String