## Simple Decrypt Bytes

This step decrypts binary data using Java AES/CBC/PKCS5Padding and a secret key.  It is assumed that the bytes
were encrypted by the Simple Encrypt Bytes step as the random IV is transmitted as part of the data.

### Structure
1 ⇒ 1

### Input
* A record with a binary field and a secret string key

### Parameters
* `Bytes Field` - Field which holds the bytes to decrypt. (string or bytes - see Notes)
* `Secret Field` - Field which holds the secret key to use in decryption (base64 string or bytes)
* `Result Field` - Field to store the decrypted binary data.

### Output
The input record with the additional result binary data where decryption was successful.

#### Notes

* The first 16 bytes of the data to be decrypted are the Initialisation Vector for the cipher. The
  Simple Encrypt step generates a different random IV for each encryption. Therefore repeated encryption 
  of the same input will produce a different output each time. 

* The Secret Field can be any string - the SHA-256 hash value is used as the actual key, which is the
  correct length for the AES algorithm.
  
* For convenience, this step also accepts string data in the bytes field, and converts it into bytes
based on the string being UTF-8 encoded.

* If the data field or secret key field is missing or has an invalid type, then the incoming record 
  is passed through unchanged

#### See Also

* Simple Encrypt Bytes

* Decrypt Bytes
  
* Encrypt Bytes
