## Bottom X

This step accumulates a fixed number of records with the lowest values of a particular field
and emits only these records when all have been seen.

### Structure
1 => 0..1

### Input
There are no special input record requirements.

### Parameters
* `Field` - the field holding the value to test

* `Count` - the number of records to retain

### Output
Only `Count` (or less) incoming records will be output: those with the lowest value for the tested field.

#### Notes
* If there are less than `Count` records received, all will be output.

* If there are multiple records with the same value at the `Count` limit, then those received earlier will be retained

* The ordering should normally be done on values of the same type, however comparisons across type are supported
and follow the MongoDB rules for type ordering: Null < Number < String < Array < ObjectId < Boolean < Timestamp.

* The records are emitted in sorted order (based on the chosen field), retaining arrival order where sort values are equal

#### See Also
* Top X
