## CSV File Writer

This step takes incoming records and builds them into a CSV structure and writes it directly to disk.

### Structure

N => 1

### Inputs

Incoming records to be written into CSV format

### Parameters

* `Write Header` - whether a header should be added to the CSV output
* `Columns` - the field names (in order) that should be added to the CSV
* `Separator` - the separator characters to use between fields - if none is supplied, comma will be used
* `Qualifier` - the quote marks to put around field values that use the separator, only a single character can be used, 
if none is supplied then double quotes is used
* `Newline` - whether to use Unix style (\n) line separators, or Windows style (\r\n)
* `Add BOM` - whether to add the Byte Order Marker at the start of the file (needed for Excel to read UTF-8 properly)
* `Filename` - the filename to write to - if the file already exists it will be overwritten

### Output

A single record is output, containing the length of the file along with the rowCount (not including any header).

#### Notes

* There is a CSV File Writer configuration `elixir.data.csv.writable` - which means CSV files can only be written to
  a set of pre-configured directories (to prevent accidental/deliberate overwrites of sensitive data).
  By default this is ./data/out. Attempting to write elsewhere will result in a job error:
  "Write disallowed by config".

#### See Also

* CSV Reader
 
* CSV Writer
