## File Chunk Reader

This step loads bytes from a file location and outputs a sequence of records with chunks of that file
loaded as a byte array for subsequent processing.

### Structure
1 => N

### Input
None

### Parameters
 
* `File` - The file location

* `Chunk Size (kb)` - The maximum size of each chunk to be passed per record output
 
### Outputs
The input record repeated for each chunk with fields set:

* `filename` - The filename that has been loaded

* `bytes` - The byte array that holds a chunk of the file content

* `mimeType` - the file's MIME type

* `chunkIdx` - the (0-based) index of each chunk

#### Notes

* The default access rights only allow for reading files in `./data/in`, this can be changed in the config.

* Note that chunks are split at byte boundaries, not line endings, so text fields may get half a line in one chunk
  and half in the next.
 
#### See Also

* File Reader
 
* File Field Reader

* Line Delimited File Reader

* Line Delimited File Field Reader
