## Unzip File

This step takes a zip filename from an incoming field 
and unzips it to folder on disk identified by another incoming field.

### Structure

1 => 1

### Inputs

The incoming record should contain two fields. One holding the zip file location and another holding the 
folder name into which the zip contents should be extracted.

### Parameters

* `From Field` - The field holding the filename that should be unzipped
 
* `To Field` - The field holding the folder into which the zip should be extracted.

### Output

Fields are passed through unchanged, with the addition of:

* `unzip-success` - A boolean value indicating success or failure

* `unzip-error` - An error message, only present if unzip-success is false

#### Notes

* The default access rights only allow for reading files from `./data/in` and `./data/out`, this can be changed in the config.
 
* The default access rights only allow for writing files to `./data/out`, this can be changed in the config.

* If the target folder does not exist, it will be created (subject to access rights).

#### See Also

* File Zipper
