## Zip File/Directory

This step takes a file or directory name from an incoming field and zips it to a new file

### Structure

1 => 1

### Inputs

The incoming record should contain a field holding the name of the file or directory to be zipped. 
It may also include a field holding the name of the zip to be produced.

### Parameters

* `From Field` - The field holding the file or directory path that should be zipped
 
* `To Field` - The field holding the filename for the resulting zip. If the field name is blank, the `From Field`
   value is used with ".zip" appended.

### Output

Fields are passed through unchanged, with the addition of:

* `zip-success` - A boolean value indicating success or failure

* `zip-error` - An error message, only present if zip-success is false

#### Notes

* The default access rights only allow for reading files from `./data/in` and `./data/out`, this can be changed in the config.
 
* The default access rights only allow for writing files to `./data/out`, this can be changed in the config.

* The default behaviour when no `To Field` is specified is to append ".zip", so if the `From Field` value is 
  ./data/out/Demo.txt the step will try to zip the contents to ./data/out/Demo.txt.zip 
  and this will succeed as ./data/out is both readable and writable. 
  However, if you try the same thing with ./data/in, it will fail as ./data/in is not writable by default. 
  Therefore you may want to configure certain additional folders to be both readable and writable.

#### See Also

* File Zipper (AES)

