## Get Image Metadata

This step reads any available metadata from an incoming `bytes` byte array (BsonBinary) representing an image.

The metadata is provided as a new `metadata` field in the output, which (if present) is often a nested tree of metadata values.

### Structure
1 => 1

### Input
* A `bytes` field, holding image data


### Parameters

This step has no parameters

### Output
The input record with an additional field set:

* `metadata` - A nested document of the extracted metadata.

### Notes

* If the image is valid, but contains no metadata, an empty `metadata` {} nested document will be added

* If the bytes are not readable as an image, then a message will be logged and no `metadata` field will be added

