## JDBC Definition

This step prepares a query for reading from JDBC. The reading is handled by JDBC Reader, the separation allows
you to interact or reconfigure the definition dynamically, eg. by performing substitutions between this step 
and the reader.

### Structure
1 => 1

### Input
There are no input requirements

### Parameters
 
* `Database` - Choose from one of the pre-configured JDBC connection pools (defined in etc/application.conf).
 
* `Query` - The SQL query to be performed

* `Parameters` - Parameters to include as part of a prepared statement - see Notes below

* `Base JSON` - Information which should be included in each result record when the query is run. This can be
  used to either pass information from upstream into the results, or to provide default values where data is missing
  (depending on the `Preserve Null` field in JDBC Reader). Any actual results will override the same named item in base.

### Output

This step only sets up the query for the JDBC Reader to execute. The output is:

* pool - The database connection to use (a string)

* sql: The SQL to be executed (a string)

* parameters - The parameters to be substituted into the prepared statement (a nested document)

* base - The base document onto which each result should be merged (a nested document)

### Notes

SQL developers are rightly concerned about SQL Injections, where a substitution in the SQL leads to unexpected
side effects. The JDBC Writer step avoids SQL Injections by using a special syntax for substitutions:

```
SELECT * FROM MyTable WHERE Company = ?{Company}
```

This is translated into a JDBC Prepared Statement as:

```
SELECT * FROM MyTable WHERE Company = ?
```
and the prepared statement is provided with the field value of Company in the parameters as the value.

Therefore we are not performing direct substitutions and you do not need to worry about how to define your strings, 
for example WHERE "XXX" or 'XXX' depending on your SQL dialect. As long as Company is a string in the
parameters document, it will be inserted correctly into the prepared statement. Even if your string includes quotes, 
everything will be properly escaped by the JDBC driver itself.

DO NOT use $\{substitutions} for parameters in your SQL, especially when the values are from outside your control. 
This can lead to SQL injections.

The JDBC Reader handles NULL values. For example:
```
SELECT * FROM MyTable WHERE Company = ?
```

If the value of the Company parameter is null, then the syntax will be rewritten as:
```
SELECT * FROM MyTable WHERE Company IS NULL
```

because `= NULL` is not valid SQL. 


The JDBC Reader also handles "IN" parameters. For example, given parameters:
```
{ "demo": ["first", "second", "third"] }
```

you can use 

```
SELECT * FROM MyTable WHERE Company IN (?{demo})
```

which will become:

```
SELECT * FROM MyTable WHERE Company IN (?,?,?)
```

With each `?` corresponding to one of the three items in `demo`.

### See Also

* JDBC Reader
