## JDBC Updater

This step allows the updating of specified columns in JDBC rows using the primary key(s).

The step will only work when the target table has a primary key (or composite key) defined so that a 
unique row can be identified for update.

You need to specify which columns in the table are to be updated. The values are taken from the fields 
with the corresponding name in each incoming record. In other words, to update the Address and PhoneNo columns,
your record will need to include the primary key field(s) (with name(s) matching the primary key in your table)
as well as Address and PhoneNo fields. If any of these fields are missing, NULL will be used. 

The logic is similar to that in JBDC Inserter, where successful updates and failure updates can be passed into 
different chains for later processing. The output of those chains will become the output of this step.
In the absence of any success/failure chains, the step will output a single summary record, containing the 
success/failure count and elapsed time.

### Structure
1 => 0..N or N => 1 if no success/failure chains are identified

### Input
* Each input record contains both the primary keys and new values (identified by `Columns`) required to update one row in the table. 
Any other fields will be ignored.

### Parameters
* `Database` - The connection pool name that identifies which database to work with
* `Table` - The table that will be updated
* `Columns` - The columns that will be updated (comma separated list)
* `Success Chain` - The (optional) chain to call (passing the current record) when an update has been successful
* `Failure Chain` - The (optional) chain to call (passing the current record) when an update failed
* `Log Every` - The number of records at which the system should log progress

### Output

Either a summary containing

* `successCount` - The number of records successfully processed

* `failureCount` - The number of records that failed

* `elapsedTime` - The time (in milliseconds) spent running this step

or else the output from the success chain / failure chain if either or both of those were provided.

### Notes

This step corresponds to SQL syntax similar to:

``
UPDATE table SET a=b, c=d WHERE pk=e
``

So if the primary key does not match, no record will be updated. This is not classed as a failure.

A failure is an SQL Exception, for example where an updated value fails a constraint 
- for example a string is too long or a value is the wrong type. 

This UPDATE step cannot update the primary key.

### See Also

* JDBC Inserter
