## JDBC SQL Updater

This step performs a JDBC SQL UPDATE, based on values passed in from incoming records.

The step expects to receive SQL with each incoming record, which will be executed and the count of records modified
will be output to the next step in the chain.

### Structure
1 => 1

### Input
Each input record should contain the information supplied by JDBC Definition, in other words:

* `pool` (string), 
* `sql` (string), 
* `parameters` (nested document), 
* `base` (nested document). 
 
You can use JDBC Definition to configure these, or derive them yourself.

### Parameters
* `Output Count Field` - The field used to store the count of the number of records modified (leave blank to ignore).

### Output

The incoming document is passed through with the addition of a count value if `Output Count Field` is set.

### Notes

See the JDBC Definition step for examples of what information this step requires - you can run that on its own to
see how the output is structured - which is what this step is expecting as input.

### See Also

* JDBC Definition
