## Cross Join

This step will combine every record from the Right Chain with every incoming record.

Note that the right chain is loaded once and held in memory, so this can use a lot of RAM 
if the right chain is large.

### Structure
1 => N

### Input

No special input requirements

### Parameters
* `Right Chain` - The name of the right chain to run
* `Right Merge` - The list of fields from the right chain that will be merged with the incoming records.
     Use * to merge all fields.

### Output
The input record is output multiple times (once per right record) with the requested right fields added.

### Notes

* The _id is discarded by this operation as otherwise it would be duplicated from either the left or right
  side, either one of which would cause duplicate key errors if you tried to write the results back into MongoDB.

* If the right fields have the same name as the left fields, the right ones will overwrite those from the left.

### See Also

* Full Join
