## Full Join

This step will join left and right records by combining fields where the left key and right key match.
In addition, it will also output all non-matching left fields, followed by all non-matching right fields at the end.

If the left record matches multiple rights, then the left will be replicated for each right.

If the right record matches multiple lefts, then the right will be replicated for each left.

Note that the right chain is loaded once and held in memory, so this can use a lot of RAM 
if the right chain is large.

### Structure
1 => N

### Input

No special input requirements

### Parameters
* `Right Chain` - The name of the right chain to run
* `Left Fields` - The names of the left fields that form the key for the join
* `Right Fields` - The names of the right fields that form the key for the join

### Output
All records from both left and right are output by Full Join. Where multiple records from left/right match, all combinations are output.
For example, if two records from left match three records from right, there will be six records output.
Finally, all non-matching outputs are included at the end, first from the left, then from the right.

### Notes

* The _id is discarded by this operation as otherwise it would be duplicated from either the left or right
  side, either one of which would cause duplicate key errors if you tried to write the results back into MongoDB.

* If the right fields have the same name as the left fields, the right ones will overwrite those from the left.

* This is an expensive (in terms of RAM) operation, because the "not seen" records need to be held until the end. 
  If you don't need these "not seen" records, then use Inner Join, which produces the same output, 
  but without the non-matching ones at the end.

### See Also

* Cross Join

* Inner Join
