## Left Join

This step will join left and right records by combining fields where the left key and right key match.
Any left records which do not match a right record will be retained. However, any right records 
which don't match a left record will be discarded.

If the left record matches multiple rights, then the left will be replicated for each right.

If the right record matches multiple lefts, then the right will be replicated for each left.

Note that the right chain is loaded once and held in memory, so this can use a lot of RAM 
if the right chain is large.

### Structure
1 => N

### Input

No special input requirements

### Parameters
* `Right Chain` - The name of the right chain to run
* `Left Fields` - The names of the left fields that form the key for the join
* `Right Fields` - The names of the right fields that form the key for the join
* `Right Merge` - The names of the right fields to be added to the output record. Use * for all except _id.

### Output
All left records are output and perhaps duplicated if multiple rights match the same left. 

### Notes

* The left record _id is NOT discarded by this operation so if the left record is duplicated you need to take care to avoid
  duplicate key errors if you write the results back into MongoDB.

* If the right fields have the same name as the left fields, the right ones will overwrite those from the left.

### See Also

* Inner Join
