## Outer Join

This step will join left and right records by combining fields where the left key and right key match.
Any left records which do not match a right record will be retained. 

This is a somewhat unusual step in that only one right record is maintained for each key, so the number of records
output will always equal the number of (left) records incoming. 

You can use this for a more efficient solution if you know that there will be at most one right matching a left. 
If there happen to be more than one right with the same key, ones later in the sequence will overwrite earlier ones.

Note that the right chain is loaded once and held in memory, so this can use a lot of RAM 
if the right chain is large.

### Structure
1 => N

### Input

No special input requirements

### Parameters
* `Right Chain` - The name of the right chain to run
* `Left Fields` - The names of the left fields that form the key for the join
* `Right Fields` - The names of the right fields that form the key for the join
* `Right Merge` - The names of the right fields to be added to the output record. Use * for all except _id.

### Output
All left records are output and perhaps duplicated if multiple rights match the same left. 

### Notes

* The left record _id is NOT discarded by this operation. Given there is no duplication of the left record, it is 
  safe to write the results back into MongoDB.

* If the right fields have the same name as the left fields, the right ones will overwrite those from the left.

### See Also

* Left Join
