## Json Record

This step inserts Json records into the chain. These records can either
provide defaults for missing data or override existing data, depending on the 
Merge Order setting.

JsonRecord can hold either one Json object {...} or an array of Json objects \[{...},{...},...]

### Structure
1 ⇒ N

### Input
None required

### Parameters
* `Merge Order` = Keep only this - discards incoming record data and outputs 
each record in this Json.
  
* `Merge Order` = This overrides upstream - merge each record in this Json 
on top of the incoming record, overwriting those fields with the same name 
with the copy in this Json.

* `Merge Order` = This deep overrides upstream - merge each record in this Json
  on top of the incoming record, merging nested objects (deep merge) otherwise, 
  overwriting those fields with the same name with the copy in this Json.

* `Merge Order` = Upstream overrides this - merge each incoming record with each
record in this Json, overwriting those fields with the same name with the copy from 
the incoming record. This behaves like a "default" - if no value exists use this one.

* `Merge Order` = Upstream deep overrides this - merge each incoming record with each
  record in this Json, merging nested objects (deep merge) otherwise, 
  overwriting those fields with the same name with the copy from
  the incoming record. This behaves like a "default" - if no value exists use this one.

* `JSON` - The Json object or array of objects to be merged into the chain

### Output
The input record is output once for each record in this Json. So if this Json contains an
array of three records, each input will produce three output records - the result of 
merging the input record with each of the Json records independently.


#### Notes
* Use this step to provide defaults for parameters provided from outside the chain. 
For example, if we expect a field called 'abc' then we can define here {"abc": ""}
with merge order "Upstream overrides this" - so if the caller does supply "abc" we 
will use it, but if they don't we will add it as "" so later steps don't fail because
they depend on it being present.

* Use this step to fix certain parameters passed to later steps by overriding incoming 
values - for example, to force an output into a particular folder, so the user can't 
pass in a choice. 

* Use this step as an alternative to Definition steps, eg. CSV Definition - you can
supply the same structure here and by using the merge order can control which settings
get passed on
  
* "Deep" merges behave differently here's an example:

```
A = { "x": 0, "thing": { "a": 1, "b": true } }
B = { "y": 1, "thing": { "b": false, "c": "q" } } 

B overrides A: 
{ "x": 0, "y": 1, "thing": { "b": false, "c": "q" } }

B deep overrides A: 
{ "x": 0, "y": 1, "thing": { "a": 1, b": false, "c": "q" } }

```
In the "simple" override, the "thing" in B replaces the "thing" in A, so a=1 is gone.

In the "deep" override, the "thing" in B is merged with the "thing" in A, retaining a=1.

#### See Also
* 
