## Daemon Kafka Reader

This step is a variant of the Kafka Reader, designed to work with the ETL Daemon mechanism,
allowing control over cancelling and stopping the chain efficiently from the ETL Daemon module.


This step reads messages from a Kafka server

### Structure
1 => N

### Input

A record with optional kafka specific settings that will override settings set in the reference.conf file and this steps parameters.
This record is passed in automatically via setting parameters in the ETL Daemon that runs this step.

* `kafka-clientId` - the kafka clientId (optional).

* `kafka-groupId` - the kafka groupId (optional).

e.g. (set in  ETL Daemon Parameters)
```json
{
  "kafka-clientId": "myClientId",
  "kafka-groupId": "myGroupId"
}
```

### Parameters

* `Server` - the name of the server to read from (from a choice of preconfigured servers).

* `Topic` - the topic to read messages from.

* `Read As` - read the message as raw bytes, a UTF-8 encoded string, or parsed Json.

* `Group Id` - an optional group id.

### Output

On success, the incoming record is passed through once per message received with additional fields added,
depending on the mode:

* Bytes mode will add `bytes` (BsonBinary), `topicOffset` (BsonInt64), `topicPartition` (BsonInt32), `topic` (BsonString), `ts` (BsonDateTime)

* String mode will add `string` (BsonString), `topicOffset` (BsonInt64), `topicPartition` (BsonInt32), `topic` (BsonString), `ts` (BsonDateTime)

* Json mode will merge the json values into the document (potentially overwriting upstream values) and also adding
  `topicOffset` (BsonInt64), `topicPartition` (BsonInt32), `topic` (BsonString), `ts` (BsonDateTime)

### Notes

* The maximum number of records read in one request is defined by the system configuration.

* You can also follow this step with `Take First Records` to limit how many are read.

### See Also

* Kafka Reader