## Kafka Reader

This step reads messages from a Kafka server 

### Structure
1 => N

### Input

No special incoming record requirements

### Parameters

* `Server` - the name of the server to read from (from a choice of preconfigured servers).

* `Topic` - the topic to read messages from.

* `Read As` - read the message as raw bytes, a UTF-8 encoded string, or parsed Json.

* `Group Id` - an optional group id.
 
### Output

On success, the incoming record is passed through once per message received with additional fields added, 
depending on the mode:

* Bytes mode will add `bytes` (BsonBinary), `topicOffset` (BsonInt64), `topicPartition` (BsonInt32) 

* String mode will add `string` (BsonString), `topicOffset` (BsonInt64), `topicPartition` (BsonInt32)

* Json mode will merge the json values into the document (potentially overwriting upstream values) and also adding
 `topicOffset` (BsonInt64), `topicPartition` (BsonInt32)

### Notes

* The maximum number of records read in one request is defined by the system configuration.

* You can also follow this step with `Take First Records` to limit how many are read. 

### See Also
