## IMAP Read Folder

This step extracts the messages in an IMAP account folder.

### Structure
1 ⇒ N

### Input
* No input is required, by default the messages will start from message number 1. 
If Start Field is defined and contains a valid Integer (Int32) then reading will begin
from that number (1-based).

### Parameters
* `Account` - The name of the IMAP account (configured in elixir.imap in etc/application.conf)

* `Folder` - The folder to read messages from

* 'Start Field' - the field which holds the integer describing the message number to start from. 
1 is used if this is not defined.

* `Limit' - the maximum number of messages to read.

### Output
The input record with extra fields set for each message read:

* `msgNo` - the message number (1-based)

* `sent` - the timestamp of when the message was sent

* `from` - who the message was from

* `to` - the array of recipients

* `cc` - the array of cc recipients

* `replyTo` - the reply-to value (array)

* `subject` - the subject of the message

* `content` - an array of documents describing the body parts - this can be plain text, html and/or
binary data, with contentType and filename as appropriate.

#### See Also
* IMAP Folder List
