## MongoDB Aggregation Match

This step is a helper to construct a MongoDB aggregation. It is usually used after an Aggregation Definition Step
to introduce field values into the aggregation more easily than via string substitutions.

### Structure
1 => 1

### Input
The input is expected to contain an `aggregation` field holding a valid JSON "\[...\]" aggregation as a String. 
If this isn't found, then an empty "\[\]" will be used instead.

### Parameters

* `Prepend` - indicates these matches should be prepended to the aggregation (more efficient)

* `Test Field` - the field in the MongoDB collection to test agains

* `Comparison` - the comparison operation (Eequals, Greater Than etc.)
 
* `Value Field` - the field in the incoming record holding the value use for comparison 


### Output
A single output record for each input record containing an updated aggregation pipeline (string):

#### Notes
* This step just builds/updates the aggregation field based on the match criteria and incoming values

* If a value field is missing from the incoming record, then that particular match is excluded. You can use
 this to handle cases where you want to vary between a fixed value (include it) or all values (remove it upstream).

* This step is usually followed by the MongoDB Reader which does the work, however other steps may be
  added in between to further customise the structure.

* The aggregation is a string rather than an actual array because MongoDB cannot store aggregation
  pipelines because they have field names beginning with $ which is disallowed.

#### See Also

* MongoDB Aggregation Definition

* MongoDB Aggregation Skip
