## Atomic Integer

This step reads and increments an integer value in MongoDB in a thread-safe way so that multiple
concurrent calls will each receive a different incrementing value. 

### Structure
1 => 1

### Input
Any input is allowed

### Parameters

* `Database` - the MongoDB database holding the collection to update

* `Collection` - the collection to update

* `_id` - the unique identified of the record holding the integer value

* `Integer Field` - the name of the integer field which will be incremented

* `Result Field` - the field in the outgoing record which holds the incremented integer value

### Output
A single record containing the incoming record with the addition of the result field holding an incremented integer.  

#### Notes
* Even if multiple calls are made concurrently, the Atomic Integer action is atomic, so only one
requester will see each incremented integer value.

#### See Also
* MongoDB Find One and Update

* MongoDB Atomic Integer Field
 