## MongoDB Delete Where (Field)

This step allows deleting of MongoDB records that match certain criteria. For each record received, it will
use the `Keys` fields to delete one or more records (at most one record if the key fields are unique).

If there are no `Keys` fields defined, the step will do nothing (rather than delete all!).
If any `Keys` field is missing from the input document, that document will be ignored.

In this variant, the name of the collection being operated on is dynamic. 
For safety, the name of the database is still fixed.

### Structure
N => 1

### Input
Records consisting of a collection name field (a string) and Key fields, which must all be present 
for a delete to happen

### Parameters

* `Database` - the MongoDB database holding the collection to update

* `Cltn. Field` - the incoming string field holding the name of the collection to update

* `Keys` - the list of key fields which are used to filter the records for deleting
 

### Output
A single record containing: 

* `elapsedTime` - how long the step took to run from the first to last document processed

* `count` - how many records were deleted

#### Notes

* If the incoming record does not contain a string in `Cltn. Field` then no action will be taken 
 
* The keys criteria need not uniquely identify a single document in the target collection. 
If no match is found, there is nothing to delete. If one match is found, one document is deleted.
If many documents are found, they are all deleted. 

#### See Also

* MongoDB Delete All (Field)

* MongoDB Delete All (Once)

* MongoDB Delete Where
