## MongoDB Rename Collection

This step renames a MongoDB collection. If Drop Target is true, any existing collection in the target
location is deleted as part of the action. Otherwise, if Drop Target is false, the step will fail if the
target collection already exists.

This is an N => 1 step which runs at the end of all preceding steps, before continuing to further steps.
Therefore, you can build and index a collection under one name and then switch to another name as part 
of the same chain.

### Structure
N => 1

### Input

No input requirements

### Parameters

* `Database` - the MongoDB database holding the collection to update

* `From Collection` - the collection to rename

* `To Collection` - the new name for the collection (within the same database)

* `Drop Target` - if true, any existing target collection will be removed, if false, the 
   target collection must not exist. 

### Output

No incoming records are passed through. A single empty record is output upon success, allowing downstream
steps to proceed. To avoid the confusion of an apparently empty output, 
this output record has a single field { "renamed": true }

#### Notes
* Any indexes on the original collection will remain on the renamed collection.

#### See Also

* MongoDB Delete All (Field)

* MongoDB Delete All
