## MongoDB Updater

This step allows modification of existing MongoDB records. For each record received, it will
use the `Keys` fields to select one or more records (at most one record if the key fields are unique).
It will then set the value of the `Fields` fields to match those of the input record. 

If any `Keys` field is missing from the input document, no update will be done. 
If any `Fields` field is missing from the input document, the update will unset 
that field in the matching database documents. 

### Structure
N => 1

### Input
Records consisting of Key fields, which must all be present for an update to happen

### Parameters

* `Database` - the MongoDB database holding the collection to update

* `Collection` - the collection to update

* `Keys` - the list of key fields which must exist in each input record else that record will be ignored

* `Fields` - the list of update fields, whose names+values will be used to update the target document(s)
that match the key criteria. 

### Output
A single record containing: 

* `elapsedTime` - how long the step took to run from the first to last document processed

* `count` - how many records were updated

#### Notes
* The keys criteria need not uniquely identify a single document in the target collection. 
If no match is found, there is nothing to update. If one match is found, one document is updated.
If many documents are found, they are all updated. 

* If multiple documents can be updated by one input record, the order of input records may be important, 
as one document could be updated several times in the course of processing the input.

#### See Also
* MongoDB Writer

* MongoDB Version Updater

* MongoDB Updater (Field)
