## MongoDB Version Updater

This step adds a record to MongoDB with a "validFrom" field based on the current time. 
For each record received, it will use the `Keys` fields to identify a previous version of the record
and if found, will set the "validUntil" field to be a millisecond earlier than the new validFrom record.

To ensure all records are unique, a new _id (UUID String) will be generated for each version.

If any `Keys` field is missing from the input document, no update will be done. 

### Structure
1 => 1

### Input
Records consisting of Key fields, which must all be present for an update to happen

### Parameters

* `Database` - the MongoDB database holding the collection to update

* `Collection` - the collection to update

* `Keys` - the list of key fields which must exist in each input record else that record will be ignored

### Output
The input record is passed through, with the addition of an automatically generated _id (UUID string) and validFrom field (BsonDateTime)

#### Notes
* The keys criteria should uniquely identify a single document in the target collection. 

#### See Also
* MongoDB Writer

* MongoDB Updater
