## MongoDB Writer Field

This step writes records into MongoDB, using a field in each record to control which collection that record is written to.
If that field is missing, the record will be ignored. After all records are processed, a summary record is output.

### Structure
N => 1

### Input
Any record structure allowed - only those with the named collection field will be processed

### Parameters

* `Database` - the MongoDB database holding the collection to update

* `Collection Field` - the string field holding the collection name to update

* `Remove Cltn. Field` - whether to remove the collection field from the record being written

* `Batch Size` - the number of documents to batch into a single insert
 

### Output
A single record containing: 

* `elapsedTime` - how long the step took to run from the first to last document processed

* `skipped` - how many records were skipped because they did not have a collection field
  
* `count` - how many records were updated

#### Notes
* The caller must ensure that any fields defined as unique (like _id) are indeed unique. 

* Any fields that begin with dollar sign ($) will be converted. For example "$name" will become <dollar>name, to meet MongoDB field
naming requirements. 

* Any fields that contain a dot (.) will be converted. For example "my.name" will become my<dot>name, to meet MongoDB field requirements.

* Batching is limited to records targetting the same collection - if every record has a different collection name, then
  there can be no batching

#### See Also
* MongoDB Updater

* MongoDB TeeWriter

* MongoDB Writer