## Add Page Numbers

This step adds page numbers to a PDF file held in a field called `bytes`

### Structure
1 ⇒ 1

### Input
* One field is required `bytes` - the pdf data
* An optional integer field `start` can be supplied, which will be the value numbering starts at.
Numbering will start at 1 by default. 

### Parameters
* `Template` - The template for the page numbering, use the special substitution # for the page number 
and ## for the total page count (wrapped with dollar/curly brackets as usual).
* `Font` - The font to use for the page labels (one of the standard PDF Fonts)
* `Font Size` - The font size to use for the page labels
* `Left Margin` - The left margin width of the page (in pts)
* `Right Margin` - The right margin width of the page (in pts)
* `Bottom Margin` - The bottom margin width of the page (in pts)
* `Alignment` - The text may be left/centre/right aligned.

### Output
The input record with the bytes updated to pdf content with the numbering added to each page

### Notes

* Only standard PDF Fonts are supported, which only include ASCII characters. You cannot put full unicode
  (eg. Chinese characters) in your template as the standard PDF fonts don't support them. 

* Left and Right alignment are based on page margins, which may not exactly match your margins, particularly
if they are not equal (eg. an extra gutter for binding)

* Using the ## page count substitution makes no sense when the start value is not 1, as the count is based only 
  on the number of pages in this document, so you could end up with Page 5 of 3.

* You can substitute other values into the template from the incoming document, for example if you have a
total page count across multiple documents, you could use it instead of ##, hence combining
an incoming `start` field and an overall total you can handle a variety of orders for document construction.

* You don't need to include page numbers at all... you can use this step to insert any footer text across every page.
