## Render Page to Image

This step extracts a page from a PDF file held in a field called `bytes` and renders it as an image, replacing
`bytes` with that image. The page to be extracted is identified by an incoming integer field.

### Structure
1 ⇒ 1

### Input
* The field `bytes` is required - the pdf data

* A field holding an integer which represents the (1-based) page number that should be rendered.


### Parameters
* `Page Field` - The integer field which holds the (1-based) page number to be rendered

* `DPI` - the dots-per-inch resolution of the image (default 72 DPI)

### Output
The input record with a bytes field set to the image rendered from the chosen page.

In the case of an error - for example, the page is not found (outside the page range), or the page field is missing
the bytes field is removed from the output, as no image can be rendered.

### Notes

* All other fields, except bytes and mimeType pass through unchanged.

### See Also

* Render to Image
* Render to TIFF