## Render Page to TIFF

This step extracts pages from a PDF file held in a field called `bytes` and 
renders them as a series of images which are combined into a single TIFF format image which 
replaces `bytes`.

### Structure
1 ⇒ 1

### Input
* The field `bytes` is required - the pdf data


### Parameters
* `Pages` - The comma-separated list of pages (1-based) to be rendered. Leave this blank to render all pages.

* `DPI` - the dots-per-inch resolution of the image (default 72 DPI)

### Output
A single record, where the `bytes` field has been replaced by the TIFF contents of the chosen pages.

### Notes

* All other fields, except bytes and mimeType pass through unchanged.

### See Also

* Render to Image
* Render Page to Image
