## Add to Queue

This step adds a request to the Ambience queue, allowing queue engines to pick it up and execute it.

All requests must contain a string field "jobType", which is usually "rml", "docx" or "etl", 
depending on your queue engine configuration. 

Requests may contain an integer field "jobPriority". This is usually between 1 and 10.
If no value is provided, 5 is used.
Higher priority jobs (eg. jobPriority: 1) will be chosen before lower priory ones.

Requests may contain a "runAfter" field, which accepts several variants:

* A Long value representing the number of milliseconds since the 1970 epoch.
 
* A String value holding an ISO formatted timestamp, eg "2023-01-30T15:57+8" 
(notice this includes a timezone offset +8, you can also use Z for UTC).

* A BsonDateTime value

If runAfter is specified, the request will only be selected to execute 
after the timestamp has been reached

Other request fields depend on the kind of job, here are some examples:

```
{ "jobType": "rml", 
  "path": "/ElixirSamples/Report/RML/Master-Detail Report.rml",
  "mimeType": "application/pdf",
  "parameters": { "city": "Burnaby" },
  "renderDetails": {}
}
```
(mimeType, parameters and renderDetails are optional)

```
{ "jobType": "docx", 
  "path": "/ElixirSamples/Report/DocX/Customer Profile by Location.docx",
  "mimeType": "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
  "parameters": { "city": "Burnaby" }
}
```
(mimeType and parameters are optional)

```
{ "jobType": "etl", 
  "chainSet": "My Chainset",
  "chainName": "Example",
  "parameters": { "city": "Burnaby" }
}
```
(parameters is optional)
You can also use:
```
"chainSetId": "f80c1f00-6162-43c0-81d9-a8857ad7a3b5",
```
in place of the chainSet name, if you prefer.


### Structure
1 ⇒ 1

### Input
* A request document is required, you can specify this as a child of the incoming record, or else
the incoming record will be used as the request

### Parameters

* `Request Field` - the field holding the request document, if empty the whole current document is used.

### Output
The input record with:

* `queueId` - The id assigned to the request when added to the queue

### Notes

* jobRunAfter marks the earliest timestamp when a request can run. It may execute later than that, 
for example if all job engines are busy or there are higher priority requests outstanding

### See Also

* Get Queue Result
 
* Get Queue Status
