## DocX Queue Definition

This is a helper step to construct the necessary structure needed for rendering DocX
using `Add To Queue`.

You can construct this structure yourself, or else use this as a starting point and
perform substitutions before finally calling `Add To Queue`.

The output of this step will be a `request` field containing this structure 
(with example values included here):

```
{ "jobType": "docx", 
  "path": "/ElixirSamples/Report/DocX/Customer Profile by Location.docx",
  "mimeType": "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
  "parameters": { "city": "Burnaby" }
}
```

### Structure
1 ⇒ 1

### Input
* No special input requirements

### Parameters

* `Path` - the path of the DocX in the repository

* `Mime Type` - the mime-type to use when rendering. Defaults to the DocX mime-type.

* `Parameters` - a Json structure holding any parameters required by the DocX. This Json allows
    direct support for substitution, so use "city": "${CityName}" to include the field CityName 
    in your parameters.

### Output
The input record with a `request` nested document, holding the supplied field values

### Notes

### See Also

* Add to Queue
