## Http Endpoint

This is a marker step that indicates the ETL chain is usable directly by authenticated HTTP calls.

The marker can occur at any point in the chain.

### Structure
1 ⇒ 1

### Input
None required

### Parameters

* `Retain Headers` - If true, all HTTP request headers will be written into a `request.headers` field 
  as an array of {name, value} pairs. 
 
* `I18N Language` - If true, the preferred I18N language will be parsed from the 
  Accept-Language header and stored as `request.i18nLanguage`


### Output
Records are passed through with additional request values attached depending on the parameter values chosen.

#### Notes
* A marker step is effectively a label that is used to filter chains/chainsets shown
to other modules, so they are not overwhelmed with choices and perhaps see internal
chains that should not be exposed.

* The `request.i18nLanguage` value is intended for use with server-side Internationalization so
  that validation messages etc. can be translated back into the user's preferred language.

* JSON Endpoint produces all records as an array, `elxStripId` is supported to remove _id and _elxIdx

* JSON Record Endpoint produces only the first record, `elxStripId` is supported to remove _id and _elxIdx

* JSON Stream Endpoint produces records individually using line-delimited json, `elxStripId` is supported to remove _id and _elxIdx

* Bytes Endpoint produces binary data only from the first record, using the `bytes` field, with Content-Type read from `mimeType`.

* Redirect Endpoint produces only a redirect response with Location data from `elxLocation`

#### See Also
* Dataset Endpoint
* Validation Endpoint
