## S3 Delete

This step deletes a file in an AWS S3 bucket location

### Structure
1 => 1

### Input

Each incoming record should contain a path to delete.

### Parameters

* `Bucket` - the name of the bucket information to use from System Settings AWS Integration.

* `Path Field` - the incoming string field holding the path to be appended to the bucket path.

### Output

On success, the incoming record is passed through unchanged.
If the request fails, then an `error` string is added instead

### Notes

* The bucket path and incoming path strings are directly concatenated. If you need a separator slash you should put it
  on the end of the bucket path or on the start of the incoming path string (but not both!).

* If the delete fails, it will be recorded in the JobLog as an error. If the file does not exist, then 
  no error is reported

### See Also

* S3 Get

* S3 List

* S3 Put
