## Hour Counter

This step allows you to count the hours between two timestamps, using calendars. 

For example, consider a support ticket which arrives on Friday afternoon and is resolved on Wednesday morning, 
what is the turn-around time?

We need to consider support hours (9am-6pm Monday to Friday excluding public holidays).

So a strict count of hours is not enough. We need to give the step some input - the calendars to use:

* Include: Office Hours
* Exclude: Weekends
* Exclude: Public Holidays

Assuming these Calendars are defined, the step will provide the actual turn-around time.

* X hours from Friday afternoon
* 0 hours for Saturday and Sunday
* 9 hours for Monday (all day, office hours)
* 0 hours for Tuesday (public holiday)
* Y hours for Wednesday

The answer will be the number of "useful" hours elapsed X + 9 + Y.

The algorithm tests every hour elapsed from the start time until the end time, and counts those that match the calendar constraints.

### Structure
1 => 1

### Input
* The input record should contain two timestamps (either BsonDateTime or BsonLong)

### Parameters
* `From Field` - The name of the incoming start timestamp field
* `To Field` - The name of the incoming stop timestamp field
* `Result Field` - The name of the field to hold the integer result
* `Include` - A list of calendars which must match the given times
* `Exclude` - A list of calendars which must NOT match the given times

### Output
Each input record is passed through with an additional `Result Field` integer value.

### Notes

* If the stop time is less than the start time, the answer will be 0
 
#### See Also

 