##Tokenise Data

This step reads a field from an incoming record, encrypts it and returns a unique token.

This unique token may later be exchanged for the original value that was read. The value can be any BSON
type, including nested documents, arrays and binary data.

### Structure
1 => 1

### Input
This step expects the incoming record to contain a field to be extracted and exchanged for a token.

### Parameters

* `Field to Store` - The name of the field to be extracted, encrypted and recorded.
* `Token Field` - The name of the field the token string will be written to.

### Output
The step will output a record with `Token Field` holding the unique token and the `Field to Store` removed.

### Notes

* No token will be returned if the `Field to Store` does not exist.