## Row Security

This step is the ETL equivalent of the Datasets Row Security mechanism. 
A field is identified which must match the current user's credentials, only records which match
are passed through, all others are discarded. The current user's credentials include

* The user name
* Each of the user roles
* The global credential `*`

Hence if the tested field contains `*` it will be visible to all.

### Structure
1 => 0..1

### Input
No input requirements

### Parameters
* `Field` - the field to compare with the current user credentials. 
   This should either be a string, or an array of strings. If it is a string, it can be comma-delimited to identify multiple values.

### Output
The input record is passed through only if the value of the field matches at least one of the users credentials.

#### Notes
* This step uses the current user information for the ETL activity being run. For example, when run from etl-designer
  it is the designer user. When run from scheduler, it is the owner of the trigger that fired the ETL job. When run
  from a report (via a Dataset), it is the user that rendered the report.

* If the test field is an array of strings or a comma-delimited string, any individual name may match. 
  For example a user with credentials ```["Sales", "Finance"]``` will match an array with ```["QA", "Sales"]``` 
  and will also match a string with ```"QA, Sales"``` 

#### See Also

* Current Credentials
