## Daemon Timer

This step is a variant of the Timer step, designed to work with the ETL Daemon mechanism, 
allowing control over cancelling and stopping the chain efficiently from the ETL Daemon module. 

The rest of the documentation below is exactly the same as for the Timer step.

This step outputs a record at regular intervals determined by the parameters.
This step *never* terminates and can only be stopped by a subsequent terminating step
or cancellation. For example, the step "Take" 5 will take five records from the
Timer and then stop requesting records from preceding steps, so Timer will stop. 

Timer is usually the first step in a chain and is not intended for very fast (<1 second)
or very slow (>1 hour) events. Use a scheduler instead for very slow events. Very fast 
events will consume a lot of CPU resources and can prevent other parts of the system
from operating efficiently.

### Structure
1 ⇒ N

### Input
None required - any will be passed through with each timer record

### Parameters
* `Interval` - An interval in seconds between 1 second and 1 hour.

### Output
The input record with fields set:

* `timerIdx` - A sequence counter for records produced by this step, 0-based.

#### Notes
* The ETL Web UI updates at a rate independent of the timer, so you may see several
events appear in the same output update - this is just the rate of web refresh, which
is deliberately asynchronous to prevent locking the rest of the UI when event rates are
very high. The records are emitted based on the delay interval.

#### See Also
* The Scheduler Module
