## Post Raw Reader

This step simulates a POSTed form from a browser to a web application.
In this case the body of the request is plain text, rather than form data.
The result is the bytes returned by the web application.

### Structure
1 ⇒ 1

### Input
None required

### Parameters
* `URL` - The URL that the request is POSTed to

* `Client Certificate` - The Secrets (Certificate + Private Key) for client authentication over https (Optional)

* `Read Response` - Allows response headers to be retrieved as well as the response body

* `Body Field` - The field holding the body (entity) to be POSTed to the server

* `Headers` - Any headers (names + values) that need to be sent with the request


### Output
The input record with fields set:

* `success` - a boolean, true if the request succeeded

* `bytes` - the data that has been read

* `mimeType` - the mime-type of the data (if it can be determined)

* `statusCode` - the status code, eg 200, 404

* `error` - an error message (only if success = false and a message was returned)

* `headers` - either a nested object or array, if requested via `Read Response`
* 
#### Notes
* The body field can contain either a string or a nested document. 
  A nested document will be converted to the equivalent JSON string. 
  However, the Content-Type sent to the server will always be text/plain.
  (This step is useful when the server expects json, but rejects application/json - it has happened!)

* In the case of a non-successful result (ie. status code != 200) the error is logged
  and the input record is passed through with no modification. This allows you to perform
  alternate logic based on the presence or absence of the `bytes`.

* Substitutions are supported in the URL field and also in the header values.

* Header values can be substituted secrets (ie. if the resulting header after substitution begins with "{enc")

* The Client Certificate field only shows the common prefix of secrets that have both a .Certificate and .PrivateKey suffix.
  For example, AB.Certificate and AB.PrivateKey will show as `AB` - both secrets are required.

#### See Also
* Post Form Reader provides standard form posting functionality
