## Filter Ends With

This step filters records based on whether a named string field ends with a specified suffix.
Only those records where the field exists and ends with the given string are retained.

### Structure
1 => 0..1

### Input
A string field is required in the input record

### Parameters
* `Field` - the string field to be tested. 
* `Suffix` - the suffix of the field value.

### Output
Those input records with a valid string field which end with the suffix value

#### Notes
* If the string field doesn't exist or is not a string the record will be discarded

* ETL steps trim user-entered strings, so the suffix cannot begin or end with whitespace

#### See Also
* Filter Contains
* Filter Starts With 

