## Left Pad

This step pads the left side of a named string field in-place.

### Structure
1 => 1

### Input
A string field is required in the input record

### Parameters
* `Field` - the string field to be modified. 
* `Prefix` - the prefix to use when padding. Leaving this empty uses a space.
* `Length` - the desired length of the string after padding.

### Output
The input records with string `Field` field holding the previous content padded to `Length` characters.

#### Notes
* If the string field doesn't exist or is not a string the record will be passed through unchanged.

* If the string is more than `Length` characters long it will not be truncated, it will remain unchanged.

* As ETL user input is trimmed, a space cannot be entered as a prefix. Because this is a common requirement, 
an empty string will be treated as a space.

* If the prefix has more than one character, the padding will be retained from the right. For example:

```
Field value = "Hello"
Prefix = "123"
Length = 10
produces: "23123Hello" 
``` 

#### See Also
* Right Pad
