## Remove Empty Strings

This step tests for string fields which match a specified `Field RegEx` and 
contain no characters (length is zero) and removes them.

This is useful to save space when data has been loaded from a sparse column structure eg CSV:

```
A,B,C,D,E,F,G,H,I,J
WWW,,,,,,,,,VV
,,,,,XXX,,,,
,,,,,,,,,YYY
,ZZZ,,,,,,,,,
```

this wastes a lot of space as the equivalent JSON to line 1 is:

```
{ "A": "WWW", "B": "", "C": "", "D": "", "E": "", "F": "", "G": "", "H": "", "I": "", "J": "VV"}
```

and line 2 is:
```
{ "A": "", "B": "", "C": "", "D": "", "E": "", "F": "XXX", "G": "", "H": "", "I": "", "J": ""}
```

after Remove Empty Strings (on fields matching .*  - all fields) we get:

```
{ "A": "WWW", "J": "VV" }
{ "F": "XXX" }
...
```

### Structure
1 => 1

### Input
No special requirements

### Parameters
* `Field RegEx` - The string field(s) to modify. 
For example ".*" will act on all fields, whereas "\[ab\].*" will act on all fields that start with a or b.

### Output
The input record with the empty string fields with text replaced

#### Notes
* If the field value is not a string or does not exist, no change is made

#### See Also
* Replace RegExp
