## Remove Prefix

This step removes a fixed prefix from the beginning of a string field.

### Structure
1 => 1

### Input
A string field is required in the input record

### Parameters
* `Field` - the string field to be modified. 
* `Prefix` - the string to be removed from the start of the current field value.

### Output
The input record with the named field modified to include the given prefix

#### Notes
* If the field value is not a string or does not exist, no change is made

* If the field value does not start with the expected prefix, no change is made

* Because ETL data entry fields are trimmed any whitespace at the beginning 
or end of the prefix will be removed. You cannot use this step to add a prefix which
begins or ends with whitespace.

#### See Also
* Add Prefix
* Add Suffix
* Remove Suffix
